import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

/**
 * Our Client class.  This class is responsible for establishing a connection to the Server, and sending a simple message.
 * 
 * @author Marc J. McDougall
 */
public class Client {
	
	//The socket that will provide the input/output streams for communication
	private Socket socket;
	
	//The input/output streams that will be used to send data across the Sockets.
	private ObjectInputStream in;
	private ObjectOutputStream out;
	
	//A BufferedReader that will be used to read text from the console.
	private BufferedReader reader;
	
	/**
	 * Default constructor.  Used to initialize the Client, connect to the Server, and set up the data streams.
	 */
	public Client(){
		
		try{
			
			//Create a new Socket at the IP address and port found as public members of the Server class.
			socket = new Socket(Server.IP_ADDR, Server.SERVER_PORT);
			
//			DEBUG
//			System.out.println("**About to establish streams now**");
			
			//Pull the input and output streams from the Socket.
			in = new ObjectInputStream(socket.getInputStream());
			out = new ObjectOutputStream(socket.getOutputStream());
		}
		catch(IOException e){
			
			//Do nothing here, just print the stack trace.
			e.printStackTrace();
		}
		
		//Initialize the BufferedReader to read from the System console.
		reader = new BufferedReader(new InputStreamReader(System.in));
	}
	
	/**
	 * Method that will contain everything that must be done with the Client.
	 **/
	public void run(){
		
		try {
			
			//Write, to the ObjectOutputStream, the value that the user types into the console.  Note that this will block for input.
			out.writeObject(reader.readLine());
			
			//Flush the output stream to guarantee that the data will be sent at this point.
			out.flush();
			
			//Print the response from the server.  Note that this will also block for input.
			System.out.println(in.readObject());
		} 
		catch (ClassNotFoundException e){
			
			//Do nothing here, just print the stack trace.
			e.printStackTrace();
		}
		catch (IOException e) {
			
			//Do nothing here, just print the stack trace.
			e.printStackTrace();
		}
	}
	
	/**
	 * Main method that will be called at the start of the execution.  Simply creates a new Client and calls run() repeatedly.
	 * 
	 * @param args Default arguments for the Main method - unused in our example.
	 */
	public static void main(String args[]){
		
		Client c = new Client();
		
		while(true){
			
			c.run();
		}
	}
}
